/* ftnchek.h:

	Common definitions for Fortran Program Checker

    Copyright (C) 1994 by Robert K. Moniot.
    This program is free software.  Permission is granted to
    modify it and/or redistribute it, retaining this notice.
    No guarantees accompany this software.

*/

#define COPYRIGHT_DATE \
"Copyright (C) 1994, 1995 by Robert K. Moniot"
#define COPYRIGHT_NOTICE \
"This program is free software.  Permission is granted to\n\
modify it and/or redistribute it, retaining this notice.\n\
No guarantees accompany this software."
#define VERSION_NUMBER		"FTNCHEK Version 2.8 May 1995"
#define PATCHLEVEL		"Patch Level 4"
#define PROJECT_VERSION		"P2" /* Project file format version number */
	/* The following system defines should be defined with the -D
	   (for UNIX) or /DEFINE (for VMS) compiler options in the makefile,
	   not here.  They are shown here so you know what to define.
	*/

/*#define VMS*/		/* Set flag for VAX/VMS   system-dependent defns. */
/*#define UNIX*/	/* Set flag for UNIX (ATT or BSD) defns. */
#ifdef __TURBOC__
#define MSDOS		/* Set flag for MSDOS (IBM PC) */
#define T_ALLOC		/* Specify workaround for malloc limits */
#endif

#ifdef MSDOS
#define NO_FLOATING_POINT	/* No need for floating point coprocessor */
#endif
			/* For portability, declare standard routines here. */
#if defined(__STDC__) || defined(__osf__)
#include <stdlib.h>
#else
char *getenv();
char *malloc(), *calloc();
void exit();
#endif


#ifdef VMS
	/* If VMS system, define flag for extra VMS-isms in
	   iokeywds.h table unless NO_VMS_IO is defined. These
	   can be independently enabled by defining VMS_IO. */
#ifndef NO_VMS_IO
#define VMS_IO
#endif /*NO_VMS_IO*/
	/* Likewise define flag for VMS behavior in INCLUDE stmt
	   (defaulting extension, /NOLIST feature) unless
	   NO_VMS_INCLUDE is defined.  */
#ifndef NO_VMS_INCLUDE
#define VMS_INCLUDE
#endif /*NO_VMS_INCLUDE*/

#endif /*VMS*/

	/* set flag to allow options to start with '/' */
#ifndef OPTION_PREFIX_SLASH
#ifdef VMS
#define OPTION_PREFIX_SLASH
#endif
#ifdef MSDOS
#define OPTION_PREFIX_SLASH
#endif
#endif

	/* The following defines control warnings about nonstandard
	   extensions.  If ALLOW_foo is 1, warning will be given about
	   foo only if -f77 flag is set.  If ALLOW_foo is 0, warning
	   will be given regardless of -f77 flag.  In either case, the
	   extension will be correctly parsed and interpreted.  The
	   code handling these extensions is often set off by ifdef's
	   but by now it is assumed that they will always be defined
	   (0 or 1).  All these default to 0 if STRICT_SYNTAX is
	   defined, 1 otherwise.  The default can be overridden by
	   defining each option explicitly.

	   At present, there is no way to control these options at run
	   time.

	   DEC_TABS sets the default value of -tab option.
	   If INLINE_COMMENT_CHAR is not defined, ! comments will cause
	   ftnchek to choke.
	 */

#ifdef STRICT_SYNTAX
#define ALLOW_ALL 0
#else
#define ALLOW_ALL 1
#define INLINE_COMMENT_CHAR '!' /* Inline comments starting with '!' */
#endif

#ifndef DEC_TABS	/* DEC-style ugly tabbed source is off by default */
#define DEC_TABS 0
#endif

#ifndef ALLOW_DO_ENDO	/* The various DO loop extensions (including WHILE) */
#define ALLOW_DO_ENDO ALLOW_ALL
#endif
#ifndef ALLOW_DOLLARSIGNS	/* Some systems allow $ in identifiers too */
#define ALLOW_DOLLARSIGNS ALLOW_ALL
#endif
#ifndef ALLOW_FORMAT_DOLLARSIGNS /*  Allow $ control code in FORMAT */
#define ALLOW_FORMAT_DOLLARSIGNS ALLOW_ALL
#endif
#ifndef ALLOW_INCLUDE		/* The INCLUDE statement */
#define ALLOW_INCLUDE ALLOW_ALL
#endif
#ifndef ALLOW_QUOTEMARKS	/* Strings delimited by "quote marks" */
#define ALLOW_QUOTEMARKS ALLOW_ALL
#endif
#ifndef ALLOW_TYPELESS_CONSTANTS	/* Like Z'19AF' */
#define ALLOW_TYPELESS_CONSTANTS ALLOW_ALL
#endif
#ifndef ALLOW_UNDERSCORES	/* Underscores in variable names */
#define ALLOW_UNDERSCORES ALLOW_ALL
#endif
#ifndef ALLOW_UNIX_BACKSLASH	/* backslash escape in strings */
#define ALLOW_UNIX_BACKSLASH ALLOW_ALL
#endif
#ifndef ALLOW_UNIX_CPP /*  Support for Unix C preprocessor directives. */
#define ALLOW_UNIX_CPP ALLOW_ALL
#endif
#ifndef ALLOW_VARIABLE_FORMAT		/* VMS style <integer_expr> for     */
#define ALLOW_VARIABLE_FORMAT ALLOW_ALL	/* format repeat spec or field size */
#endif


		/* If STANDARD_INTRINSICS is defined, only F77 standard
		   intrinsic functions will be known to ftnchek.  Otherwise
		   there are three classes of nonstandard intrinsics:
		   common, Unix flavor, and VMS flavor.  The
		   Unix or VMS flavor will be selected if UNIX or
		   VMS rsptly is defined, unless suppressed with
		   NO_UNIX_INTRINSICS or NO_VMS_INTRINSICS.
		 */
#ifndef STANDARD_INTRINSICS

#define NONSTD_INTRINSICS	/* Common nonstandard intrinsic functions */

#ifdef UNIX
#ifndef NO_UNIX_INTRINSICS
#define UNIX_INTRINSICS		/* UNIX intrinsic functions */
#endif
	/* Note: RAND syntax varies.  Define RAND_NO_ARG to make ftnchek
	   expect X=RAND(). By default ftnchek expects X=RAND(ISEED).
	 */
#endif

#ifdef VMS
#ifndef NO_VMS_INTRINSICS
#define VMS_INTRINSICS		/* VMS intrinsic functions */
#endif
#endif

#endif

		/* Define to tolerate embedded blanks in numeric consts unless
		   feature turned off by defining NO_BLANKS_IN_NUMBERS. */
#ifndef NO_BLANKS_IN_NUMBERS
#define BLANKS_IN_NUMBERS
#endif

		/* Define default source and output file extensions.  These
		 * can be overridden by defines on compiler commandline.
		 */
#ifndef DEF_SRC_EXTENSION
#ifdef VMS
#define DEF_SRC_EXTENSION ".for"		/* VMS default extension */
#endif
#ifdef MSDOS
#define DEF_SRC_EXTENSION ".for"		/* IBM PC default extension */
#endif
#endif /* DEF_SRC_EXTENSION */

#ifndef DEF_SRC_EXTENSION
#define DEF_SRC_EXTENSION ".f"		/* Unix and all others */
#endif
		/* define default list-file extension */
#ifndef DEF_LIST_EXTENSION
#define DEF_LIST_EXTENSION ".lis"
#endif
		/* define default project-file extension */
#ifndef DEF_PROJ_EXTENSION
#define DEF_PROJ_EXTENSION ".prj"
#endif
		/* define default declaration-file extension */
#ifndef DEF_DCL_EXTENSION
#define DEF_DCL_EXTENSION ".dcl"
#endif
		/* define project-file name for case of input from stdin */
#ifndef STDIN_PROJ_FILENAME
#define STDIN_PROJ_FILENAME "ftnchek.prj"
#endif

#ifndef ENV_PREFIX		/* prefix for option environment variables */
#define ENV_PREFIX "FTNCHEK_"
#endif

#ifndef MAXLINE
#define MAXLINE 132	/* Maximum input line length.  Ignores past this. */
#endif
#ifndef MAXIDSIZE
#define MAXIDSIZE 31	/* Longest identifier allowed */
#endif
#ifndef MAX_SRC_TEXT
#define MAX_SRC_TEXT (20*66) /* Longest text string of a token */
#endif
#ifndef MAX_CHAR_CODE
#define MAX_CHAR_CODE 255 /* Largest possible value of a char (8 bits here) */
#endif
#ifndef MAX_INCLUDE_DEPTH
#define MAX_INCLUDE_DEPTH 16	/* Max nesting depth of include files */
#endif
#ifndef MAXEXPRTEXT
#define MAXEXPRTEXT 15		/* length of expr text saved in arg lists */
#endif
#ifndef ENV_INCLUDE_VAR
#define ENV_INCLUDE_VAR "INCLUDE" /* name of env variable for include dir */
#endif

#ifndef DEFAULT_INCLUDE_DIR
#ifdef UNIX
#define DEFAULT_INCLUDE_DIR "/usr/include"
#endif
#ifdef VMS
#define DEFAULT_INCLUDE_DIR "SYS$LIBRARY:"
#endif
#ifdef MSDOS
#define DEFAULT_INCLUDE_DIR "\\include"
#endif
#endif

#define KEEP_ARG_NAMES 1	/* option was formerly experimental */

		/* Definitions of table sizes
		     Constraints:
			STRSPACESZ > 20*72 so max f77 statement will fit
			LOCSYMTABSZ+GLOBSYMTABSZ < HASHSZ so hashtab never full
		 */

#define KEYHASHSZ 195	/* Size of keyword hashtable -- do not change */
#define INTRINS_HASHSZ 326 /* Chosen to give few clashes -- change with care */

#ifdef SMALL_MACHINE		/* Use these for e.g. IBM PC */
#ifndef HASHSZ			/* Hint: pick one with no square factors */
#define HASHSZ 798     /* SMALL_MACHINE Size of symbol hashtable */
#endif
#ifndef STRSPACESZ
#define STRSPACESZ 4000 /* SMALL_MACHINE chunk size of string space */
#endif
#ifndef LOCSYMTABSZ
#define LOCSYMTABSZ 300 /* SMALL_MACHINE Size of local symbol table */
#endif
#ifndef GLOBSYMTABSZ
#define GLOBSYMTABSZ 400 /* SMALL_MACHINE Size of global symbol table */
#endif
#ifndef PARAMINFOSPACESZ
#define PARAMINFOSPACESZ 20 /* SMALL_MACHINE ParamInfo structs per chunk */
#endif
#ifndef TOKHEADSPACESZ
#define TOKHEADSPACESZ 50 /* SMALL_MACHINE TokenListHeaders per chunk */
#endif
#ifndef TOKENSPACESZ
#define TOKENSPACESZ 200 /* SMALL_MACHINE tokens per token space chunk */
#endif
#ifndef ARGLISTHEADSZ
#define ARGLISTHEADSZ	300 /* SMALL_MACHINE argument headers per chunk */
#endif
#ifndef ARGLISTELTSZ
#define ARGLISTELTSZ	1000 /* SMALL_MACHINE argument list elts per chunk */
#endif
#ifndef COMLISTHEADSZ
#define COMLISTHEADSZ	200 /* SMALL_MACHINE common list headers per chunk */
#endif
#ifndef COMLISTELTSZ
#define COMLISTELTSZ	1000 /* SMALL_MACHINE common elts per chunk */
#endif
#ifndef PTRSPACESZ
#define PTRSPACESZ	200  /* SMALL_MACHINE ptrs-to-arraydim per chunk */
#endif

#else  /* end if SMALL_MACHINE */

#ifdef LARGE_MACHINE		/* use these if space is no problem */
#ifndef HASHSZ		/* must be <= max int  */
#define HASHSZ 20930	 /* LARGE_MACHINE Size of symbol hashtable */
#endif
#ifndef STRSPACESZ
#define STRSPACESZ 10000 /* LARGE_MACHINE chunk size of string space */
#endif
#ifndef LOCSYMTABSZ
#define LOCSYMTABSZ 8000 /* LARGE_MACHINE Size of local symbol table */
#endif
#ifndef GLOBSYMTABSZ
#define GLOBSYMTABSZ 12000 /* LARGE_MACHINE Size of global symbol table */
#endif
#ifndef PARAMINFOSPACESZ
#define PARAMINFOSPACESZ 200 /* LARGE_MACHINE ParamInfo structs per chunk */
#endif
#ifndef TOKHEADSPACESZ
#define TOKHEADSPACESZ 500 /* LARGE_MACHINE TokenListHeaders per chunk */
#endif
#ifndef TOKENSPACESZ
#define TOKENSPACESZ 10000 /* LARGE_MACHINE tokens per token space chunk */
#endif
#ifndef ARGLISTHEADSZ
#define ARGLISTHEADSZ	15000 /* LARGE_MACHINE argument headers per chunk */
#endif
#ifndef ARGLISTELTSZ
#define ARGLISTELTSZ	50000	/* LARGE_MACHINE argument list elts per chunk */
#endif
#ifndef COMLISTHEADSZ
#define COMLISTHEADSZ	10000 /* LARGE_MACHINE common list headers per chunk */
#endif
#ifndef COMLISTELTSZ
#define COMLISTELTSZ	50000 /* LARGE_MACHINE common elts per chunk */
#endif
#ifndef PTRSPACESZ
#define PTRSPACESZ	2000 /* LARGE_MACHINE Max number of ptrs to arraydim */
#endif

#else		/* Defaults: Use these for average-size applications */

#ifndef HASHSZ
#define HASHSZ 2002	/* Default Size of symbol hashtable */
#endif
#ifndef STRSPACESZ
#define STRSPACESZ 10000 /* Default chunk size of string space */
#endif
#ifndef LOCSYMTABSZ
#define LOCSYMTABSZ 800 /* Default Size of local symbol table */
#endif
#ifndef GLOBSYMTABSZ
#define GLOBSYMTABSZ 1200 /* Default Size of global symbol table */
#endif
#ifndef PARAMINFOSPACESZ
#define PARAMINFOSPACESZ 50 /* Default ParamInfo structs per chunk */
#endif
#ifndef TOKHEADSPACESZ
#define TOKHEADSPACESZ 200 /* Default TokenListHeaders per chunk */
#endif
#ifndef TOKENSPACESZ
#define TOKENSPACESZ 1000 /* Default tokens per token space chunk */
#endif
#ifndef ARGLISTHEADSZ
#define ARGLISTHEADSZ	1500 /* Default argument headers per chunk */
#endif
#ifndef ARGLISTELTSZ
#define ARGLISTELTSZ	5000	/* Default argument list elts per chunk */
#endif
#ifndef COMLISTHEADSZ
#define COMLISTHEADSZ	1000 /* Default common list headers per chunk */
#endif
#ifndef COMLISTELTSZ
#define COMLISTELTSZ	4000 /* Default common elts per chunk */
#endif
#ifndef PTRSPACESZ
#define PTRSPACESZ	400 /* Default Max number of ptrs to arraydim */
#endif

#endif /* end if LARGE_MACHINE else */

#endif/*end if SMALL_MACHINE else*/

/*  Default BpW = 4 bytes per word, which matches many machines.
    If the Fortran code does not declare explicit sizes of
    numeric variables (e.g. REAL*8), then the value of BpW will
    not matter, since the table conforms to the standard in that
    sizeof(INTEGER)=sizeof(REAL), and sizeof(DOUBLE)=sizeof(COMPLEX)
    =2*sizeof(REAL).  If the code does declare explicit sizes of
    numeric types, then the value of BpW will matter if explicit
    and default sizes are expected to match.  If you want to
    suppress warnings of this kind, you may change BpW to match
    your hardware.  Under the -portability option, explicit and
    default sizes never match: e.g. passing REAL*8 where DOUBLE
    PRECISION expected.  None of this applies to CHARACTER data:
    the default size (1) is well-defined, and the standard does
    not specify the ratio of sizeof(CHARACTER) to sizeof(REAL). */

#ifndef BpW
#define BpW 4	/* Bytes per Word: might want to use sizeof(float) instead */
#endif


#define FALSE 0
#define TRUE 1

#define NO_COL_NUM ((unsigned)999)/* Impossible column number to suppress
				 * printing in error messages
				 */
#define NO_LINE_NUM ((unsigned)0)/* Ditto for line number to suppress flushing
				 * of line if error not in local context
				 */
#ifndef WRAP_COLUMN
#define WRAP_COLUMN 79		/* When to wrap error messages to next line */
#endif

#define OOPS_NONFATAL 0		/* Severity of "oops" messages */
#define OOPS_FATAL 1

/* Shared variable and function defns start here */

#ifdef MAIN
#define SHARED		/* (nothing) */
#else
#define SHARED extern	/* Non-main routines declare shared vars extern */
#endif

#define PRIVATE static	/* For non-shared functions */

		/* Ftnchek has no need of floating-point calculations,
		   so to allow it to run on machines without coprocessor,
		   we neutralize the few floating-point operations.
		*/
#ifdef NO_FLOATING_POINT
typedef long DBLVAL;
#else
typedef double DBLVAL;
#endif

SHARED FILE
            *input_fd,  /* Input file */
            *list_fd,	/* Output file for listing */
	    *dcl_fd,	/* Output type declaration file */
	    *project_fd;/* Project file for symtab info summary */
SHARED char *current_filename,	/* name of current input file */
	    *top_filename;	/* name of toplevel parent input file */
SHARED int incdepth;


		/* Declare variables for command line options */
#ifdef MAIN
#define OPT(Type,Name,Value) Type Name=Value
#else
#define OPT(Type,Name,Value) extern Type Name
#endif

		/* These ones are not yet options, but are variables
		   so that they can become options some day. */

OPT(int,allow_do_endo,ALLOW_DO_ENDO);
OPT(int,allow_dollarsigns,ALLOW_DOLLARSIGNS);
OPT(int,allow_format_dollarsigns,ALLOW_FORMAT_DOLLARSIGNS);
OPT(int,allow_include,ALLOW_INCLUDE);
OPT(int,allow_quotemarks,ALLOW_QUOTEMARKS);
OPT(int,allow_typeless_constants,ALLOW_TYPELESS_CONSTANTS);
OPT(int,allow_variable_format,ALLOW_VARIABLE_FORMAT);
OPT(int,allow_underscores,ALLOW_UNDERSCORES);
OPT(int,allow_unix_backslash,ALLOW_UNIX_BACKSLASH);
OPT(int,allow_unix_cpp,ALLOW_UNIX_CPP);

		/* End of options that are not yet command-line options */


OPT(int,unix_backslash,FALSE);	/* Treat backslash as escape */
OPT(int,print_call_tree,FALSE);	/* Print the call tree */
OPT(int,print_xref_list,FALSE);	/* Print subprogram cross-references */
OPT(int,decls_required,FALSE);	/* List all undeclared identifiers */
OPT(int,div_check,FALSE);	/* Check for possible division by zero */
OPT(int,ext_def_check,TRUE);	/* Check defined status of externals*/
OPT(int,f77_standard,FALSE);	/* Warn of non-f77 constructs */
OPT(int,help_screen,FALSE);	/* Print out help screen */
OPT(int,hollerith_check,TRUE);	/* Warn about holleriths under -port */
OPT(int,library_mode,FALSE);	/* Set used-flag for all modules in file */

#ifdef EOLSKIP
OPT(int,eol_is_space,TRUE);	/* Treat contd stmt linebreaks as space */
#endif

OPT(int,do_list,FALSE);		/* Listing flag */
OPT(int,novice_help,TRUE);	/* Extra help for novices */
OPT(int,port_check,FALSE);	/* Portability warnings */
OPT(int,pretty_flag,TRUE);	/* Warnings on deceiving appearances */
OPT(int,make_project_file,FALSE);/* Save symtab defns in .prj file */
OPT(int,pure_functions,TRUE);	/* Assume functions are pure */
OPT(int,print_ref_list,FALSE);	/* Print reference (who-calls-who) list */
OPT(int,sixclash,FALSE);	/* To check if names unique in 1st 6 chars */
OPT(int,dec_tabs,DEC_TABS);	/* DEC-style tabbed source */
OPT(int,print_topo_sort,FALSE);	/* Topological sort of modules */
OPT(int,do_symtab,FALSE);	/* For symbol table printout */
OPT(int,trunc_check,TRUE);	/* Check for truncation pitfalls */
#ifdef VCG_SUPPORT
OPT(int,print_vcg_list,FALSE);	/* Print call graph in vcg format */
#endif
OPT(int,verbose,TRUE);		/* Verbose output format */
OPT(int,volatile_flag,FALSE);	/* Assume volatile vars and comblocks */
		/* Debugging flags */
OPT(int,debug_latest,FALSE);	/* debug the latest addition */
OPT(int,debug_glob_symtab,FALSE);/* global symtab contents */
OPT(int,debug_parser,FALSE);	/* grammar debug via DBG statements */
OPT(int,debug_hashtab,FALSE);	/* hash table contents */
OPT(int,debug_loc_symtab,FALSE); /* local symtab contents */
OPT(int,show_resources,FALSE);	/* space avail and used */
OPT(int,debug_lexer,FALSE);	/* list of tokens as scanned */
#ifdef MAIN
extern int yydebug;		/* grammar debug via yydebug */
#endif
		/* Declare variables for commandline settings */
OPT(int,argcheck_strictness,3);	/* Strictness for checking args */
OPT(int,array_arg_check,3);/* Check array argument dims & size  */
OPT(int,max_stmt_col,72);	/* End of statement field ( <= MAXLINE )*/
OPT(int,comcheck_strictness,3);	/* 0 (no check) to 3 (exact type & size) */
OPT(int,make_dcls,0);		/* sum of: 0 (none), 1 (all), */
				/* 2 (undeclared), 4 (compact), 8 (keywords */
				/* lowercase), 16 (variables and constants */
				/* lowercase), 32 (exclude sf3 internal */
				/* variables), 64 (use * comment starter), */
				/* 128 (use 'c' comment starter). */
OPT(int,usage_check,3);		/* Print set/used/ubs checks on variables */
OPT(int,local_wordsize,BpW);	/* Bytes per word to use for default sizes */
OPT(int,given_wordsize,BpW);	/* User's request as per -wordsize=n  */
OPT(int,wrap_column,WRAP_COLUMN);/* For wrapping error messages */

			/* Shorthands for checking control settings */
#define check_args_off	(argcheck_strictness == 0)
#define check_args_number (argcheck_strictness&01)
#define check_args_type	(argcheck_strictness&02)
#define check_args_all	(argcheck_strictness == 3)
#define check_array_dims (array_arg_check&01) /* levels 1 and 3 */
#define check_array_size (array_arg_check&02) /* levels 2 and 3 */
#define check_set_used	(usage_check&01) /* levels 1 and 3 */
#define check_unused	(usage_check&02) /* levels 2 and 3 */
#define check_com_off	(comcheck_strictness == 0) /* no checking common */
#define check_com_lengths (comcheck_strictness >= 2) /* match lengths */
#define check_com_byname (comcheck_strictness == 3) /* match var by var */
#define check_com_tree (volatile_flag&&check_set_used) /* Check undef errors */
#define check_volatile_com (volatile_flag)/* Check not saved */

		/* Declare variables for commandline StrSettings */
OPT(char,*out_fname,(char *)NULL);	/* Output filename */
#ifdef ALLOW_INCLUDE
OPT(char,*include_path,(char *)NULL);	/* An include-file directory */
#endif

SHARED unsigned
    line_num,		/* line num of current char */
    col_num,		/* column num of current char */
    next_line_num,	/* line num of lookahead char */
    next_col_num;	/* column num of lookahead char */

SHARED unsigned
    tab_count,		/* Count of tabs in noncomment lines exc in strings */
    error_count,	/* Count of syntax error messages per file */
    warning_count;	/* Count of warning messages per file */

		/* Resource usage information: */
SHARED unsigned long
    tot_line_count,	/* total source lines (stmts + comments) */
    tot_stmt_line_count,/* total source stmt lines  */
    tot_exec_stmt_count,/* count of executable stmts in program */
    tot_module_count,	/* count of modules in program */
    exec_stmt_count,	/* count of executable stmts in module */
    max_exec_stmt_count,/* max number of executable stmts in any module */
    max_loc_symtab,	/* number of local symtab entries used */
    max_glob_symtab,	/* number of global symtab entries used */
    max_loc_strings,	/* chars of local stringspace used */
    max_srctextspace,	/* chars of source text space used */
    max_paraminfo,	/* number of param info structs used */
    max_tokenlists,	/* number of tokenlists constructed */
    max_token_space,	/* number of tokens used */
    max_ptrspace,	/* number of pointers used */

    glob_strings_used,		/* chars of global stringspace used */
    arglist_element_used,	/* arg array elements used */
    arglist_head_used,		/* arg heads used (1 per call) */
    comlist_element_used,	/* com array elements used */
    comlist_head_used;		/* com heads used (1 per defn) */

SHARED int
    equivalence_flag,   /* true while parsing EQUIVALENCE statement */
    initial_flag,	/* true while only label or initial keywords read */
    implicit_flag,	/* true while parsing IMPLICIT statement */
    implicit_letter_flag, /* true while getting letters in IMPLICIT list */
    implicit_type_given,/* true if IMPLICIT type statement found */
    implicit_none,	/* true if IMPLICIT NONE statement found */
    prev_token_class,	/* token class of last-returned token */
    curr_stmt_class;	/* Token class of current stmt's leading token */

		/* Define linked-list structure for include-path list */
#ifdef ALLOW_INCLUDE
typedef struct IPNode {
  struct IPNode *link;		/* next path on the list */
  char *include_path;		/* one path (full directory name) */
} IncludePathNode;

SHARED IncludePathNode *include_path_list; /* header to the list */
#endif

		/* Declare shared routines */
	/* in advance.c */
void init_scan(),finish_scan(),open_include_file();
int flush_line_out();


	/* in ftnchek.c */
void print_a_line(), yyerror(), syntax_error(), msg_tail(),
     warning(), ugly_code(), nonstandard(), nonportable(),
  oops_message(),oops_tail();

	/* in forlex.c */
int yylex();
void implied_id_token();

	/* in fortran.y/fortran.c */
int yyparse();
void init_parser();

	/* in intrinsics.c */
unsigned long init_intrins_hashtab();

	/* in keywords.c */
void init_keyhashtab();

	/* in pgsymtab.c */

void check_arglists(),check_comlists(),check_com_usage(),visit_children();

	/* in symtab.c */

void init_tables(), init_globals(), init_symtab(), note_filename();

char * token_name();

	/* in exprtype.c */
void init_typesizes();

	/* in project.c */
void				/* project file routines */
 proj_file_out(),proj_file_in();
